#
# This is the user-interface definition of a Shiny web application. You can
# run the application by clicking 'Run App' above.
#
# Find out more about building applications with Shiny here:
#
#    http://shiny.rstudio.com/
#

library(shiny)

# Define UI for application that draws a histogram
shinyUI(fluidPage(

  # Application title
  titlePanel("Sequential SEIR model"),

  # Sidebar with a slider input for number of bins
  sidebarLayout(
    sidebarPanel(
      numericInput("R_t", label = h3("R0"), value = 2.5),
      textOutput("Initial Values"),
      numericInput("InitS", label = h3("S"), value = 1000000, min=1),
      numericInput("InitE", label = h3("E"), value = 90, min=0),
      numericInput("InitI", label = h3("I"), value = 100, min=0),
      numericInput("InitR", label = h3("R"), value = 0, min=0),
      textAreaInput("sakugenseq", h3("Reduction percentages"), "0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0\n0",height=300),
      numericInput("meanl", label = h3("Average incubation period"), value = 6, min=0.0001),
      numericInput("meani", label = h3("Average infectious period"), value = 10, min=0.0001),
      numericInput("nofr", label = h3("Number of additional reductions"), value = 1),
      actionButton("actionButton", label = "Submit")
    ),

    # Show a plot of the generated distribution
    mainPanel(
      textOutput(outputId = "desc"),
      plotOutput("distPlot"),plotOutput("distPlot2"),plotOutput("distPlot3"),
      dataTableOutput("out_cum")
    )
  )
))
