#
# This is the server logic of a Shiny web application. You can run the
# application by clicking 'Run App' above.
#
# Find out more about building applications with Shiny here:
#
#    http://shiny.rstudio.com/
#

library(shiny)
library(deSolve)
library(stringr)



# Define server logic required to draw a histogram
shinyServer(function(input, output) {

  calc <- eventReactive(input$actionButton,{
    R_t    <- input$R_t
    if (input$InitS<1){InitS<-1}else{InitS <- input$InitS}
    if (input$InitE<0){InitE<-0}else{InitE <- input$InitE}
    if (input$InitI<0){InitI<-0}else{InitI <- input$InitI}
    if (input$InitR<0){InitR<-0}else{InitR <- input$InitR}
    population <- InitS + InitE + InitI + InitR

    meanl<-input$meanl
    meani<-input$meani
    SEIR <- function(t, state, parameters){
      with(as.list(c(state, parameters)),{
        dS <- -Rt / meani * S / population * I
        dE <- Rt / meani * S / population * I - E / meanl
        dI <- E / meanl - I / meani
        dR <- I / meani
        list(c(dS, dE, dI, dR))
      })
    }


    parameters <- c(Rt = R_t)
    times <- c(0,1)
    initial <- c(S=InitS, E=InitE, I=InitI, R=InitR)
    out2 <- ode(y = initial, times = times, func = SEIR, parms = parameters)
    #plot(out2)

    sakugen<-na.omit(as.numeric(str_split(input$sakugenseq,"\n")[[1]]))/100
    if (length(sakugen)>1096){sakugen<-sakugen[1:1096]}
    Rtseq<-(1-sakugen)*R_t

    nRt<-length(Rtseq)

    out_cum<-out2[1,]
    for(d in c(1:nRt)){
      times <- c(0,1)
      if (d==1) {initial2<-out2[1,2:5]} else {initial2<-out3[2,2:5]}
      out3 <- ode(y = initial2, times = times, func = SEIR, parms = c(Rt = Rtseq[d]))
      out_cum <- rbind(out_cum,out3[2,])
    }
    return (out_cum)
  })

  calc_more1 <- eventReactive(input$actionButton,{
    R_t    <- input$R_t
    if (input$InitS<1){InitS<-1}else{InitS <- input$InitS}
    if (input$InitE<0){InitE<-0}else{InitE <- input$InitE}
    if (input$InitI<0){InitI<-0}else{InitI <- input$InitI}
    if (input$InitR<0){InitR<-0}else{InitR <- input$InitR}
    population <- InitS + InitE + InitI + InitR

    meanl<-input$meanl
    meani<-input$meani
    SEIR <- function(t, state, parameters){
      with(as.list(c(state, parameters)),{
        dS <- -Rt / meani * S / population * I
        dE <- Rt / meani * S / population * I - E / meanl
        dI <- E / meanl - I / meani
        dR <- I / meani
        list(c(dS, dE, dI, dR))
      })
    }


    parameters <- c(Rt = R_t)
    times <- c(0,1)
    initial <- c(S=InitS, E=InitE, I=InitI, R=InitR)
    out2 <- ode(y = initial, times = times, func = SEIR, parms = parameters)

    sakugen<-na.omit(as.numeric(str_split(input$sakugenseq,"\n")[[1]]))/100
    if (length(sakugen)>1096){sakugen<-sakugen[1:1096]}
    Rtseq<-R_t*(1-sakugen-(input$nofr/InitS))

    nRt<-length(Rtseq)

    out_cum<-out2[1,]
    for(d in c(1:nRt)){
      times <- c(0,1)
      if (d==1) {initial2<-out2[1,2:5]} else {initial2<-out3[2,2:5]}
      out3 <- ode(y = initial2, times = times, func = SEIR, parms = c(Rt = Rtseq[d]))
      out_cum <- rbind(out_cum,out3[2,])
    }
    return (out_cum)
  })

  output$distPlot <- renderPlot({

    out_cum <- calc()
    ploty <- -out_cum[2:nrow(out_cum),2]+out_cum[1:(nrow(out_cum)-1),2]

    #barplot(ploty,names.arg=c(1:(nrow(out_cum)-1)),lty=1,type="l",ylim=c(0,max(ploty)),xlab="day",ylab="New Cases")
    barplot(ploty,names.arg=c(1:(nrow(out_cum)-1)),ylim=c(0,max(ploty)),xlab="day",ylab="New Cases")


  })
  output$distPlot2 <- renderPlot({

    out_cum <- calc()
    ploty <- out_cum[2:nrow(out_cum),3]+out_cum[2:nrow(out_cum),4]

    barplot(ploty,names.arg=c(1:(nrow(out_cum)-1)),ylim=c(0,max(ploty)),xlab="day",ylab="Active Cases")


  })
  output$distPlot3 <- renderPlot({

    out_cum <- calc()
    ploty <- out_cum[2:nrow(out_cum),3]+out_cum[2:nrow(out_cum),4]+out_cum[2:nrow(out_cum),5]

    plot(x=c(1:(nrow(out_cum)-1)),y=ploty,lty=1,type="l",ylim=c(0,max(ploty)),xlab="day",ylab="Cumulative Cases")


  })

  displayRt <- eventReactive(input$actionButton,{
    dt<-c((1-na.omit(as.numeric(str_split(input$sakugenseq,"\n")[[1]]))/100)*input$R_t,NA)
    return (dt)
  })

  output$out_cum <- renderDataTable({
    out_cum<-calc()
    plotRt<-displayRt()
    plot<-data.frame(day=c(0:(nrow(out_cum)-1)),Rt=plotRt,S=out_cum[,2],E=out_cum[,3],I=out_cum[,4],R=out_cum[,5])
  })

  numberofreduce <- eventReactive(input$actionButton,{
    return(input$nofr)
  })
  output$desc <- renderText({
    out_cum<-calc()
    out_cum2<-calc_more1()
    diffcase<-out_cum2[nrow(out_cum2),2]-out_cum[nrow(out_cum),2]
    nor<-numberofreduce()
    paste("If we reduce the frequency of contact by an additional ", nor, " people, there will be ", diffcase ," fewer cases by day ", nrow(out_cum)-1 ,".",sep="")
  })
})
